/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_test.c,v 1.84 2006/08/31 19:24:13 bgoglin Exp $";
 
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__request.h"
#include "mx__endpoint.h"
#include "mx__error.h"

int mx__test_common(mx_endpoint_t, mx_request_t *request,
		    mx_status_t *status);

MX_FUNC(mx_return_t)
mx_test(mx_endpoint_t ep,
	mx_request_t *request,
	mx_status_t *status,
	uint32_t *result)
{
  MX__MUTEX_LOCK(&ep->lock);
  MX__EP_STATS_INC(ep, test);
  mx__luigi(ep);
  *result = mx__test_common(ep, request, status);
  if (!*result)
    MX__EP_STATS_INC(ep, noncompleted_test);
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}

int
mx__test_common(mx_endpoint_t ep,
		mx_request_t *request,
		mx_status_t *status)
{
  union mx_request *r;
  uint64_t match_info;
  uint32_t ctxid;

  r = *request;
  match_info = r->basic.status.match_info;
  ctxid = CTXID_FROM_MATCHING(ep, match_info);

  if (likely(r->basic.state & MX__REQUEST_STATE_COMPLETED)) {
#ifndef MX_KERNEL
    if (unlikely(MX_DEBUG_CSUM && mx__opt.csum
		 && (r->basic.type ==  MX__REQUEST_TYPE_RECV
		     || r->basic.type == MX__REQUEST_TYPE_RECV_LARGE
		     || r->basic.type ==  MX__REQUEST_TYPE_RECV_SELF
		     || r->basic.type == MX__REQUEST_TYPE_RECV_SHM))) {
      if (r->basic.status.msg_length && 
	  r->basic.status.code == MX_STATUS_SUCCESS) {
	uint32_t csum;
	mx_segment_t *seg;
	seg = r->recv.segments+0;
	csum = mx_checksum(seg->segment_ptr, r->basic.status.msg_length);
	if (csum != r->basic.status.match_info >> 48) {
	  r->basic.status.code =
	    mx__error_req(ep, "Bad checksum:computed 0x%x, sent 0x%x",
			  r, MX_STATUS_ABORTED, csum, 
			  (int)(r->basic.status.match_info >> 48));
	}
	r->basic.status.match_info &= UINT64_C(0x0000ffffffffffff);
      }
    }
#endif
    mx_memcpy(status, &r->basic.status, sizeof (*status));
    /* Remove from doneq. */
    if (likely(!r->basic.acquired_by_wait_any))
      mx__spliceout_request(&ep->ctxid[ctxid].doneq, r);
    else
      ep->acquired_by_wait_any_count--;
    mx__rl_free(ep, r);
    *request = 0;
    return 1;
  } else if (r->basic.state & MX__REQUEST_STATE_BUFFERED
	     && ep->dead_count <= MX__MAX_DEAD
#if MX_ONE_SIDED
      && !(r->send.basic.status.match_info & MX__ONESIDED_PUT)
#endif
      && mx__opt.zombie_send
      ) {
    r->basic.state |= MX__REQUEST_STATE_DEAD;
    mx_memcpy(status, &r->basic.status, sizeof (*status));
    *request = 0;
    ep->dead_count += 1;
    return 1;
  } else {
    return 0;
  }
}

#ifdef MX_VERSIONED_SYMS

void mx__conv_status_to_v1(mx_status_t *p)
{
  struct mx_status_v1 {
    mx_status_code_t code;
    struct {
      uint32_t stuff[MX_SIZEOF_ADDR/4];
    } source;
    uint64_t match_info;
    uint32_t msg_length;
    uint32_t xfer_length;
    void *context;
  } *v1;
  mx_status_t s;
  s = *p;
  v1 = (struct mx_status_v1*)p;
  v1->code = s.code;
  memcpy(&v1->source, &s.source,MX_SIZEOF_ADDR);
  v1->match_info = s.match_info;
  v1->msg_length = s.msg_length;
  v1->xfer_length = s.xfer_length;
  v1->context = s.context;
}

mx_return_t
mx_test_v1(mx_endpoint_t ep, mx_request_t *request, mx_status_t *status, 
	   uint32_t *result)
{
  mx_return_t ret;
  ret = mx_test(ep, request, status, result);
  mx__conv_status_to_v1(status);
  return ret;
}

__asm__(".symver mx_test_v1,mx_test@MX_0.0");

#endif
